<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccLatePayment extends Model 
{

    protected $table = 'acc_late_payment';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'date', 'customer_id', 'sales_invoice_id', 'amount');

    public function sales_invoice()
    {
        return $this->belongsTo('AccSalesInvoice', 'sales_invoice_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function customer()
    {
        return $this->belongsTo('AccCustomer', 'customer_id');
    }

}