<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccPayment extends Model 
{

    protected $table = 'acc_payment';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'date', 'reference', 'description', 'bank_account_id', 'amount', 'paid_by_type', 'other_name', 'customer_id', 'supplier_id', 'total', 'fixed_total', 'out_of_balance', 'purchase_invoice_id', 'title', 'footer_id', 'inventory_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function customer()
    {
        return $this->belongsTo('AccCustomer', 'customer_id');
    }

    public function supplier()
    {
        return $this->belongsTo('AccSupplier', 'supplier_id');
    }

    public function accounts()
    {
        return $this->hasMany('AccProfitLossAccount', 'payment_id');
    }

    public function items()
    {
        return $this->hasMany('AccItem', 'payment_id');
    }

    public function footer()
    {
        return $this->belongsTo('AccFooter', 'footer_id');
    }

    public function bank_account()
    {
        return $this->belongsTo('AccBankAccount', 'bank_account_id');
    }

    public function purchase_invoice()
    {
        return $this->belongsTo('AccPurchaseInvoice', 'purchase_invoice_id');
    }

    public function inventory()
    {
        return $this->belongsTo('AccInventory', 'inventory_id');
    }

}