<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccReceipt extends Model 
{

    protected $table = 'acc_receipt';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'date', 'reference', 'paid_by_type', 'other_name', 'customer_id', 'supplier_id', 'bank_account_id', 'description', 'total', 'fixed_total', 'sales_invoice_id', 'out_of_balance', 'amount', 'title', 'footer_id', 'cleared_at', 'inventory_id');

    public function bank_account()
    {
        return $this->belongsTo('AccBankAccount', 'bank_account_id');
    }

    public function customer()
    {
        return $this->belongsTo('AccCustomer', 'customer_id');
    }

    public function supplier()
    {
        return $this->belongsTo('AccSupplier', 'supplier_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function accounts()
    {
        return $this->hasMany('AccProfitLossAccount', 'receipt_id');
    }

    public function items()
    {
        return $this->hasMany('AccItem', 'receipt_id');
    }

    public function footer()
    {
        return $this->belongsTo('AccFooter', 'footer_id');
    }

    public function sales_invoice()
    {
        return $this->belongsTo('AccSalesInvoice', 'sales_invoice_id');
    }

    public function inventory()
    {
        return $this->belongsTo('AccInventory', 'inventory_id');
    }

}