<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccReconciliation extends Model 
{

    protected $table = 'acc_reconciliation';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'date', 'bank_account_id', 'statement_balance', 'status', 'discrepancy');

    public function bank_account()
    {
        return $this->belongsTo('AccBankAccount', 'bank_account_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}