<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateChallengeLevelsTable extends Migration {

	public function up()
	{
		Schema::create('challenge_levels', function(Blueprint $table) {
			$table->bigInteger('challenge_id')->unsigned();
			$table->integer('level');
			$table->integer('limit');
			$table->string('description', 2048);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('challenge_levels');
	}
}