<?php

namespace App\Models\Orgs;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Institution extends Eloquent {

	protected $table = 'institutions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('lat', 'lng', 'ico');

	public function getActionFacts()
	{
		return $this->hasMany('Events');
	}

	public function getChallenges()
	{
		return $this->hasMany('Challenge');
	}

	public function addQuizes()
	{
		return $this->hasMany('Quiz');
	}

	public function getCategory()
	{
		return $this->belongsTo('InstitutionCategory');
	}

	public function getResponsible()
	{
		return $this->belongsTo('User', 'responsible_id');
	}

	public function getActivities()
	{
		return $this->hasMany('Activity');
	}

	public function getUsers()
	{
		return $this->hasMany('User');
	}

}