<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTopicsTable extends Migration {

	public function up()
	{
		Schema::create('topics', function(Blueprint $table) {
			$table->increments('id');
			$table->string('video_id');
			$table->string('title', 60);
			$table->string('image_pathname');
			$table->text('content');
			$table->integer('created_by');
			$table->integer('updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('topics');
	}
}