<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesTable extends Migration {

	public function up()
	{
		Schema::create('courses', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 60);
			$table->smallInteger('duration');
			$table->enum('difficulty', array('beginner', 'intermediate', 'advanced'));
			$table->text('description')->nullable();
			$table->string('summary');
			$table->string('image_pathname', 255);
			$table->integer('created_by');
			$table->integer('updated_by');
			$table->string('video_id');
			$table->boolean('is_promoted');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('courses');
	}
}