<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAccountsTable extends Migration {

	public function up()
	{
		Schema::create('accounts', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('number');
			$table->string('iban');
			$table->text('note');
			$table->bigInteger('bank_id')->unsigned();
			$table->bigInteger('user_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('accounts');
	}
}