<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTblCoursesTable extends Migration {

	public function up()
	{
		Schema::create('tbl_courses', function(Blueprint $table) {
			$table->increments('id');
			$table->string('course_title', 150);
			$table->string('course_slug', 200);
			$table->string('meta_desc', 255);
			$table->string('meta_key', 255);
			$table->integer('parent_id')->default('0');
			$table->tinyInteger('sort_order');
			$table->string('course_image', 200);
			$table->integer('course_video_qty');
			$table->integer('course_user_qty');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tbl_courses');
	}
}