<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class YearSubject extends Eloquent {

	protected $table = 'year_subjects';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name');

	public function themes()
	{
		return $this->hasMany('Theme');
	}

	public function categories()
	{
		return $this->hasMany('Category');
	}

}