<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Theme extends Model 
{

    protected $table = 'themes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'year_subject_id');

    public function exercises()
    {
        return $this->belongsTo('Exercise');
    }

    public function yearSubject()
    {
        return $this->belongsTo('YearSubject');
    }

    public function links()
    {
        return $this->hasMany('Link');
    }

}