<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePrixTable extends Migration {

	public function up()
	{
		Schema::create('prix', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('id_vin')->unsigned();
			$table->float('montant');
			$table->integer('quantite')->unsigned()->default('1');
			$table->float('taille')->nullable();
			$table->float('volume')->nullable();
			$table->text('description')->nullable();
			$table->string('image', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('prix');
	}
}