<?php

namespace app;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AvailabilityCalendar extends Model 
{

    protected $table = 'availability_calendars';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function Availability()
    {
        return $this->hasMany('Availability', 'id');
    }

    public function Calendar()
    {
        return $this->hasMany('Calendar', 'id');
    }

}