<?php

namespace app;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function Company()
    {
        return $this->hasOne('Company', 'id');
    }

    public function User()
    {
        return $this->hasOne('User', 'id');
    }

}