<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVariantesTable extends Migration {

	public function up()
	{
		Schema::create('variantes', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_producto')->unsigned();
			$table->text('referencia');
			$table->decimal('precio');
			$table->decimal('precio_oferta');
			$table->string('disponibilidad', 255);
			$table->string('EAN', 15);
			$table->integer('orden');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('variantes');
	}
}