<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTasksTable extends Migration {

	public function up()
	{
		Schema::create('tasks', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('project_id')->unsigned();
			$table->integer('assessor_id')->unsigned();
			$table->integer('language_id')->unsigned();
			$table->string('name');
			$table->string('email');
			$table->timestamp('deadline')->nullable();
			$table->timestamp('availability_from')->nullable();
			$table->timestamp('availability_to')->nullable();
			$table->string('brand');
			$table->string('department');
			$table->integer('task_status_id')->unsigned();
			$table->boolean('bill_client');
			$table->boolean('pay_assessor');
			$table->string('phone');
		});
	}

	public function down()
	{
		Schema::drop('tasks');
	}
}