<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRecurrencesTable extends Migration {

	public function up()
	{
		Schema::create('recurrences', function(Blueprint $table) {
			$table->increments('id');
			$table->date('start_date');
			$table->enum('recurrence_interval', array('weekly', 'daily'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('recurrences');
	}
}