<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReservationsTable extends Migration {

	public function up()
	{
		Schema::create('reservations', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('student_id')->unsigned()->index();
			$table->bigInteger('coach_id')->unsigned()->index();
			$table->bigInteger('slot_id')->index();
			$table->boolean('has_digital_analysis')->default(false);
			$table->enum('status', array('pending', 'accepted', 'analysis_pending', 'finished', 'canceled'));
			$table->mediumText('feedback');
			$table->string('stripe_payment_intent_id')->nullable();
			$table->timestamps();
			$table->softDeletes();
			$table->decimal('amount')->nullable();
			$table->string('currency');
		});
	}

	public function down()
	{
		Schema::drop('reservations');
	}
}