<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Message extends Model 
{

    protected $table = 'messages';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function conversation()
    {
        return $this->belongsTo('Conversation');
    }

    public function sender()
    {
        return $this->morphTo();
    }

    public function recivier()
    {
        return $this->morphTo();
    }

}