<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Group extends Eloquent {

	protected $table = 'groups';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function posts()
	{
		return $this->hasMany('App\Post');
	}

	public function users()
	{
		return $this->belongsToMany('App\User', 'group_users');
	}

}