<?php

namespace App;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $fillable = array('email', 'nombre', 'apellidos', 'categoria', 'role', 'avatar', 'telefono', 'fax', 'direccion', 'oficina', 'sitiopersonal', 'google_scholar', 'cv', 'educacion_html', 'research_interests_html', 'biografia_html', 'publicaciones_html', 'editorial_html', 'presentaciones_html');
	protected $hidden = array('password', 'remember_token');

	public function selected_publications()
	{
		return $this->belongsToMany('App\Selected_Publications');
	}

	public function users_working_papers()
	{
		return $this->belongsToMany('App\Working_Paper');
	}

	public function proyectos_users()
	{
		return $this->belongsToMany('App\Proyectos');
	}

	public function role()
	{
		return $this->hasOne('App\Role');
	}

	public function Categoria_profesor()
	{
		return $this->hasOne('App\Categoria');
	}

}