<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('email', 255);
			$table->string('nombre', 60);
			$table->string('apellidos', 100);
			$table->integer('categoria')->unsigned();
			$table->text('password');
			$table->string('remember_token', 100);
			$table->integer('role');
			$table->string('avatar', 255);
			$table->string('telefono', 20);
			$table->string('fax', 20);
			$table->string('direccion', 255);
			$table->string('oficina', 255);
			$table->string('sitiopersonal', 255);
			$table->string('google_scholar', 255);
			$table->string('cv', 255);
			$table->text('educacion_html');
			$table->text('research_interests_html');
			$table->text('biografia_html');
			$table->text('publicaciones_html');
			$table->text('editorial_html');
			$table->text('presentaciones_html');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}