<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectTable extends Migration {

	public function up()
	{
		Schema::create('project', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->text('short_descr');
			$table->integer('owner')->unsigned();
			$table->date('start_date');
			$table->date('end_date');
			$table->boolean('wizard_mode');
			$table->boolean('restrictions');
			$table->integer('project_type')->unsigned();
			$table->integer('project_level')->unsigned();
			$table->integer('program1')->unsigned();
			$table->integer('program2')->unsigned();
			$table->integer('cost_center')->unsigned();
			$table->integer('project_director')->unsigned();
			$table->integer('head_of_project')->unsigned();
			$table->integer('project_status')->unsigned();
			$table->integer('guarantor1')->unsigned();
			$table->integer('guarantor2')->unsigned();
			$table->integer('guarantor3')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('project');
	}
}