<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('project', function(Blueprint $table) {
			$table->foreign('owner')->references('id')->on('resource')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project', function(Blueprint $table) {
			$table->foreign('project_type')->references('id')->on('project_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project', function(Blueprint $table) {
			$table->foreign('project_level')->references('id')->on('project_level')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project', function(Blueprint $table) {
			$table->foreign('program1')->references('id')->on('program')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project', function(Blueprint $table) {
			$table->foreign('program2')->references('id')->on('program')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project', function(Blueprint $table) {
			$table->foreign('cost_center')->references('id')->on('cost_center')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project', function(Blueprint $table) {
			$table->foreign('project_director')->references('id')->on('resource')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project', function(Blueprint $table) {
			$table->foreign('head_of_project')->references('id')->on('resource')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project', function(Blueprint $table) {
			$table->foreign('project_status')->references('id')->on('project_status')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project', function(Blueprint $table) {
			$table->foreign('guarantor1')->references('id')->on('resource')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project', function(Blueprint $table) {
			$table->foreign('guarantor2')->references('id')->on('resource')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project', function(Blueprint $table) {
			$table->foreign('guarantor3')->references('id')->on('resource')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_mapping', function(Blueprint $table) {
			$table->foreign('pm_definition_role')->references('id')->on('pm_definition_role')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('participants', function(Blueprint $table) {
			$table->foreign('id_project')->references('id')->on('project')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('participants', function(Blueprint $table) {
			$table->foreign('resource')->references('id')->on('resource')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('participants', function(Blueprint $table) {
			$table->foreign('role')->references('id')->on('role_mapping')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('resource', function(Blueprint $table) {
			$table->foreign('office')->references('id')->on('office')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('wbs', function(Blueprint $table) {
			$table->foreign('id_project')->references('id')->on('project')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('wbs', function(Blueprint $table) {
			$table->foreign('id_parent')->references('id')->on('wbs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('wbs', function(Blueprint $table) {
			$table->foreign('owner')->references('id')->on('resource')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('wbs_sequence', function(Blueprint $table) {
			$table->foreign('id_project')->references('id')->on('project')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('wbs_sequence', function(Blueprint $table) {
			$table->foreign('id_activity')->references('id')->on('wbs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('wbs_sequence', function(Blueprint $table) {
			$table->foreign('id_predecessor')->references('id')->on('wbs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('wbs_contributors', function(Blueprint $table) {
			$table->foreign('id_project')->references('id')->on('project')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('wbs_contributors', function(Blueprint $table) {
			$table->foreign('id_activity')->references('id')->on('wbs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('wbs_contributors', function(Blueprint $table) {
			$table->foreign('contributor')->references('id')->on('resource')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('business_case', function(Blueprint $table) {
			$table->foreign('id_project')->references('id')->on('project')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('business_case', function(Blueprint $table) {
			$table->foreign('responsible_for_approval')->references('id')->on('resource')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('funding', function(Blueprint $table) {
			$table->foreign('id_project')->references('id')->on('project')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('funding', function(Blueprint $table) {
			$table->foreign('category')->references('id')->on('category_funding')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_requisites', function(Blueprint $table) {
			$table->foreign('id_project')->references('id')->on('project')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_requisites', function(Blueprint $table) {
			$table->foreign('deliverable_connected')->references('id')->on('wbs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('steering_commitee', function(Blueprint $table) {
			$table->foreign('id_project')->references('id')->on('project')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('steering_commitee', function(Blueprint $table) {
			$table->foreign('resource')->references('id')->on('resource')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_unit', function(Blueprint $table) {
			$table->foreign('id_project')->references('id')->on('project')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_unit', function(Blueprint $table) {
			$table->foreign('unit_key_person')->references('id')->on('resource')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_unit', function(Blueprint $table) {
			$table->foreign('critical_resources')->references('id')->on('pjt_unit_critical_resources')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stakeholder', function(Blueprint $table) {
			$table->foreign('id_project')->references('id')->on('project')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stakeholder', function(Blueprint $table) {
			$table->foreign('stakeholder_flag')->references('id')->on('stakeholder_flag')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_scope', function(Blueprint $table) {
			$table->foreign('id_project')->references('id')->on('project')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('group_companies_involved', function(Blueprint $table) {
			$table->foreign('id_project')->references('id')->on('project')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('group_companies_involved', function(Blueprint $table) {
			$table->foreign('key_impact')->references('id')->on('key_impact')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('group_companies_involved', function(Blueprint $table) {
			$table->foreign('key_people')->references('id')->on('resource')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('corporate_functions', function(Blueprint $table) {
			$table->foreign('id_project')->references('id')->on('project')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('corporate_functions', function(Blueprint $table) {
			$table->foreign('key_impact')->references('id')->on('key_impact')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('corporate_functions', function(Blueprint $table) {
			$table->foreign('key_people')->references('id')->on('resource')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('corporate_processes', function(Blueprint $table) {
			$table->foreign('id_project')->references('id')->on('project')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('corporate_processes', function(Blueprint $table) {
			$table->foreign('key_impact')->references('id')->on('key_impact')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('corporate_processes', function(Blueprint $table) {
			$table->foreign('key_people')->references('id')->on('resource')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('it_area_involved', function(Blueprint $table) {
			$table->foreign('id_project')->references('id')->on('project')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('it_area_involved', function(Blueprint $table) {
			$table->foreign('key_impact')->references('id')->on('key_impact')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('it_area_involved', function(Blueprint $table) {
			$table->foreign('key_people')->references('id')->on('resource')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('connected_projects', function(Blueprint $table) {
			$table->foreign('id_project')->references('id')->on('project')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('connected_projects', function(Blueprint $table) {
			$table->foreign('key_impact')->references('id')->on('key_impact')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('connected_projects', function(Blueprint $table) {
			$table->foreign('key_people')->references('id')->on('resource')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pjt_unit_critical_resources', function(Blueprint $table) {
			$table->foreign('id_project')->references('id')->on('project')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pjt_unit_critical_resources', function(Blueprint $table) {
			$table->foreign('resource_id')->references('id')->on('resource')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user', function(Blueprint $table) {
			$table->foreign('resource_id')->references('id')->on('resource')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_role', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_role', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('pm_definition_role')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('permission', function(Blueprint $table) {
			$table->foreign('operation_id')->references('id')->on('operation')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('permission', function(Blueprint $table) {
			$table->foreign('object_id')->references('id')->on('object')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('permission', function(Blueprint $table) {
			$table->foreign('scope_id')->references('id')->on('scope')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_permission', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('pm_definition_role')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_permission', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permission')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('project', function(Blueprint $table) {
			$table->dropForeign('project_owner_foreign');
		});
		Schema::table('project', function(Blueprint $table) {
			$table->dropForeign('project_project_type_foreign');
		});
		Schema::table('project', function(Blueprint $table) {
			$table->dropForeign('project_project_level_foreign');
		});
		Schema::table('project', function(Blueprint $table) {
			$table->dropForeign('project_program1_foreign');
		});
		Schema::table('project', function(Blueprint $table) {
			$table->dropForeign('project_program2_foreign');
		});
		Schema::table('project', function(Blueprint $table) {
			$table->dropForeign('project_cost_center_foreign');
		});
		Schema::table('project', function(Blueprint $table) {
			$table->dropForeign('project_project_director_foreign');
		});
		Schema::table('project', function(Blueprint $table) {
			$table->dropForeign('project_head_of_project_foreign');
		});
		Schema::table('project', function(Blueprint $table) {
			$table->dropForeign('project_project_status_foreign');
		});
		Schema::table('project', function(Blueprint $table) {
			$table->dropForeign('project_guarantor1_foreign');
		});
		Schema::table('project', function(Blueprint $table) {
			$table->dropForeign('project_guarantor2_foreign');
		});
		Schema::table('project', function(Blueprint $table) {
			$table->dropForeign('project_guarantor3_foreign');
		});
		Schema::table('role_mapping', function(Blueprint $table) {
			$table->dropForeign('role_mapping_pm_definition_role_foreign');
		});
		Schema::table('participants', function(Blueprint $table) {
			$table->dropForeign('participants_id_project_foreign');
		});
		Schema::table('participants', function(Blueprint $table) {
			$table->dropForeign('participants_resource_foreign');
		});
		Schema::table('participants', function(Blueprint $table) {
			$table->dropForeign('participants_role_foreign');
		});
		Schema::table('resource', function(Blueprint $table) {
			$table->dropForeign('resource_office_foreign');
		});
		Schema::table('wbs', function(Blueprint $table) {
			$table->dropForeign('wbs_id_project_foreign');
		});
		Schema::table('wbs', function(Blueprint $table) {
			$table->dropForeign('wbs_id_parent_foreign');
		});
		Schema::table('wbs', function(Blueprint $table) {
			$table->dropForeign('wbs_owner_foreign');
		});
		Schema::table('wbs_sequence', function(Blueprint $table) {
			$table->dropForeign('wbs_sequence_id_project_foreign');
		});
		Schema::table('wbs_sequence', function(Blueprint $table) {
			$table->dropForeign('wbs_sequence_id_activity_foreign');
		});
		Schema::table('wbs_sequence', function(Blueprint $table) {
			$table->dropForeign('wbs_sequence_id_predecessor_foreign');
		});
		Schema::table('wbs_contributors', function(Blueprint $table) {
			$table->dropForeign('wbs_contributors_id_project_foreign');
		});
		Schema::table('wbs_contributors', function(Blueprint $table) {
			$table->dropForeign('wbs_contributors_id_activity_foreign');
		});
		Schema::table('wbs_contributors', function(Blueprint $table) {
			$table->dropForeign('wbs_contributors_contributor_foreign');
		});
		Schema::table('business_case', function(Blueprint $table) {
			$table->dropForeign('business_case_id_project_foreign');
		});
		Schema::table('business_case', function(Blueprint $table) {
			$table->dropForeign('business_case_responsible_for_approval_foreign');
		});
		Schema::table('funding', function(Blueprint $table) {
			$table->dropForeign('funding_id_project_foreign');
		});
		Schema::table('funding', function(Blueprint $table) {
			$table->dropForeign('funding_category_foreign');
		});
		Schema::table('project_requisites', function(Blueprint $table) {
			$table->dropForeign('project_requisites_id_project_foreign');
		});
		Schema::table('project_requisites', function(Blueprint $table) {
			$table->dropForeign('project_requisites_deliverable_connected_foreign');
		});
		Schema::table('steering_commitee', function(Blueprint $table) {
			$table->dropForeign('steering_commitee_id_project_foreign');
		});
		Schema::table('steering_commitee', function(Blueprint $table) {
			$table->dropForeign('steering_commitee_resource_foreign');
		});
		Schema::table('project_unit', function(Blueprint $table) {
			$table->dropForeign('project_unit_id_project_foreign');
		});
		Schema::table('project_unit', function(Blueprint $table) {
			$table->dropForeign('project_unit_unit_key_person_foreign');
		});
		Schema::table('project_unit', function(Blueprint $table) {
			$table->dropForeign('project_unit_critical_resources_foreign');
		});
		Schema::table('stakeholder', function(Blueprint $table) {
			$table->dropForeign('stakeholder_id_project_foreign');
		});
		Schema::table('stakeholder', function(Blueprint $table) {
			$table->dropForeign('stakeholder_stakeholder_flag_foreign');
		});
		Schema::table('project_scope', function(Blueprint $table) {
			$table->dropForeign('project_scope_id_project_foreign');
		});
		Schema::table('group_companies_involved', function(Blueprint $table) {
			$table->dropForeign('group_companies_involved_id_project_foreign');
		});
		Schema::table('group_companies_involved', function(Blueprint $table) {
			$table->dropForeign('group_companies_involved_key_impact_foreign');
		});
		Schema::table('group_companies_involved', function(Blueprint $table) {
			$table->dropForeign('group_companies_involved_key_people_foreign');
		});
		Schema::table('corporate_functions', function(Blueprint $table) {
			$table->dropForeign('corporate_functions_id_project_foreign');
		});
		Schema::table('corporate_functions', function(Blueprint $table) {
			$table->dropForeign('corporate_functions_key_impact_foreign');
		});
		Schema::table('corporate_functions', function(Blueprint $table) {
			$table->dropForeign('corporate_functions_key_people_foreign');
		});
		Schema::table('corporate_processes', function(Blueprint $table) {
			$table->dropForeign('corporate_processes_id_project_foreign');
		});
		Schema::table('corporate_processes', function(Blueprint $table) {
			$table->dropForeign('corporate_processes_key_impact_foreign');
		});
		Schema::table('corporate_processes', function(Blueprint $table) {
			$table->dropForeign('corporate_processes_key_people_foreign');
		});
		Schema::table('it_area_involved', function(Blueprint $table) {
			$table->dropForeign('it_area_involved_id_project_foreign');
		});
		Schema::table('it_area_involved', function(Blueprint $table) {
			$table->dropForeign('it_area_involved_key_impact_foreign');
		});
		Schema::table('it_area_involved', function(Blueprint $table) {
			$table->dropForeign('it_area_involved_key_people_foreign');
		});
		Schema::table('connected_projects', function(Blueprint $table) {
			$table->dropForeign('connected_projects_id_project_foreign');
		});
		Schema::table('connected_projects', function(Blueprint $table) {
			$table->dropForeign('connected_projects_key_impact_foreign');
		});
		Schema::table('connected_projects', function(Blueprint $table) {
			$table->dropForeign('connected_projects_key_people_foreign');
		});
		Schema::table('pjt_unit_critical_resources', function(Blueprint $table) {
			$table->dropForeign('pjt_unit_critical_resources_id_project_foreign');
		});
		Schema::table('pjt_unit_critical_resources', function(Blueprint $table) {
			$table->dropForeign('pjt_unit_critical_resources_resource_id_foreign');
		});
		Schema::table('user', function(Blueprint $table) {
			$table->dropForeign('user_resource_id_foreign');
		});
		Schema::table('user_role', function(Blueprint $table) {
			$table->dropForeign('user_role_user_id_foreign');
		});
		Schema::table('user_role', function(Blueprint $table) {
			$table->dropForeign('user_role_role_id_foreign');
		});
		Schema::table('permission', function(Blueprint $table) {
			$table->dropForeign('permission_operation_id_foreign');
		});
		Schema::table('permission', function(Blueprint $table) {
			$table->dropForeign('permission_object_id_foreign');
		});
		Schema::table('permission', function(Blueprint $table) {
			$table->dropForeign('permission_scope_id_foreign');
		});
		Schema::table('role_permission', function(Blueprint $table) {
			$table->dropForeign('role_permission_role_id_foreign');
		});
		Schema::table('role_permission', function(Blueprint $table) {
			$table->dropForeign('role_permission_permission_id_foreign');
		});
	}
}