<?php

namespace App;

class Restaurant extends Eloquent {

	protected $table = 'restaurants';
	public $timestamps = true;
	protected $fillable = array('district_id', 'category_id', 'image', 'name', 'minimum_charge', 'delivery', 'phone', 'whatsapp', 'email', 'status', 'activated', 'api_token');
	protected $hidden = array('password');

	public function contacts()
	{
		return $this->morphMany('App\Contact');
	}

	public function offers()
	{
		return $this->hasMany('App\Offer');
	}

	public function orders()
	{
		return $this->hasMany('App\Order');
	}

	public function products()
	{
		return $this->hasMany('App\Product');
	}

	public function clients()
	{
		return $this->belongsToMany('App\Client');
	}

	public function notifications()
	{
		return $this->morphMany('App\Notification');
	}

	public function tokens()
	{
		return $this->morphMany('App\Token');
	}

	public function categories()
	{
		return $this->belongsToMany('App\Category');
	}

	public function district()
	{
		return $this->belongsTo('App\District');
	}

	public function payment()
	{
		return $this->belongsTo('App\Payment');
	}

}