<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRecipesTable extends Migration {

	public function up()
	{
		Schema::create('recipes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('entrant_id')->unsigned()->index();
			$table->string('language', 2)->index();
			$table->string('title', 50);
			$table->string('product_name', 50)->index();
			$table->integer('portions');
			$table->integer('preparation_time');
			$table->text('preparation_instructions');
			$table->integer('cooking_time');
			$table->text('cooking_instructions');
			$table->string('meal_type', 50)->index();
			$table->json('ingredients');
			$table->text('story');
			$table->string('picture', 50);
			$table->boolean('active')->index()->default(0);
		});
	}

	public function down()
	{
		Schema::drop('recipes');
	}
}