<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommentsTable extends Migration {

	public function up()
	{
		Schema::create('comments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('firstname', 50);
			$table->string('lastname', 50);
			$table->string('email', 50);
			$table->integer('rating')->index();
			$table->text('comment');
		});
	}

	public function down()
	{
		Schema::drop('comments');
	}
}