<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSpeakersTable extends Migration {

	public function up()
	{
		Schema::create('speakers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('slug')->index();
			$table->string('nom')->index();
			$table->string('prenom')->index();
			$table->string('lien_linkedin')->index();
			$table->string('annee')->index();
			$table->string('image')->index();
			$table->text('description')->nullable()->index();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('speakers');
	}
}