<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function role()
	{
		return $this->belongsTo('Role', 'id', 'role_id');
	}

	public function specializations()
	{
		return $this->belongsToMany('Specialization');
	}

	public function attachments()
	{
		return $this->morphToMany('Attachment', 'attachmentable');
	}

	public function methods()
	{
		return $this->belongsToMany('Method');
	}

	public function views()
	{
		return $this->hasMany('User', 'id', 'user_id');
	}

	public function areas()
	{
		return $this->belongsToMany('Area');
	}

}