<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('name', 'email');
    protected $visible = array('name', 'email');
    protected $hidden = array('password');

    public function topics()
    {
        return $this->hasManyThrough('App\Topic', 'App\UserTopic');
    }

    public function tickets()
    {
        return $this->hasMany('App\Answer', 'user_id', 'id')->orderBy('created_at', 'desc');
    }

    public function answers()
    {
        return $this->hasMany('App\Answer', 'support_id', 'id')->orderBy('created_at', 'desc');
    }

}