<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('topics_tags', function(Blueprint $table) {
			$table->foreign('topic_id')->references('id')->on('topics')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('topics_tags', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users_topics', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('users_topics', function(Blueprint $table) {
			$table->foreign('topic_id')->references('id')->on('topics')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('topic_id')->references('id')->on('topics')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('support_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('topics_tags', function(Blueprint $table) {
			$table->dropForeign('topics_tags_topic_id_foreign');
		});
		Schema::table('topics_tags', function(Blueprint $table) {
			$table->dropForeign('topics_tags_tag_id_foreign');
		});
		Schema::table('users_topics', function(Blueprint $table) {
			$table->dropForeign('users_topics_user_id_foreign');
		});
		Schema::table('users_topics', function(Blueprint $table) {
			$table->dropForeign('users_topics_topic_id_foreign');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_topic_id_foreign');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_support_id_foreign');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_user_id_foreign');
		});
	}
}