<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMenusTable extends Migration {

	public function up()
	{
		Schema::create('menus', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('site_id')->default('0');
			$table->integer('category_id')->default('0');
			$table->integer('post_id')->default('0');
			$table->string('name');
			$table->string('url');
			$table->enum('status', array('active', 'passive'));
			$table->integer('user_id')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('menus');
	}
}