<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSlidersTable extends Migration {

	public function up()
	{
		Schema::create('sliders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('category_id')->default('0');
			$table->string('name');
			$table->string('image');
			$table->integer('sorting')->default('0');
			$table->date('start_date');
			$table->date('end_date');
			$table->time('start_time');
			$table->time('end_time');
			$table->string('url');
			$table->enum('target', array('_self', '_blank'));
			$table->enum('lang', array('tr', 'en', 'ar'));
			$table->integer('user_id');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('sliders');
	}
}