<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'Users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function roles()
    {
        return $this->belongsToMany('Role');
    }

    public function teacher()
    {
        return $this->hasOne('Teacher');
    }

    public function Student()
    {
        return $this->hasOne('Student');
    }

}