<?php

namespace App;

class Resevation extends Eloquent {

	protected $table = 'Reservations';
	public $timestamps = true;

	public function site()
	{
		return $this->belongsTo('Site');
	}

	public function client()
	{
		return $this->belongsTo('User');
	}

	public function products()
	{
		return $this->belongsToMany('Product')->withPivot('reservation_products');
	}

	public function period()
	{
		return $this->belongsTo('Period', 'period_id');
	}

}