<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class News extends Model 
{

    protected $table = 'news';
    public $timestamps = true;

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function category()
    {
        return $this->belongsTo('NewsCategory');
    }

    public function views()
    {
        return $this->belongsToMany('NewsView');
    }

    public function comments()
    {
        return $this->hasMany('NewsComment');
    }

}