<?php

namespace volunteer_portal;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Volunteer extends Model 
{

    protected $table = 'volunteer';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user_ids()
    {
        return $this->hasMany('User', 'id');
    }

    public function event_id()
    {
        return $this->hasMany('Event', 'id');
    }

}