<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->decimal('price', 8,3);
			$table->string('calories', 255);
			$table->text('description');
			$table->string('image', 255);
			$table->integer('category_id')->unsigned();
			$table->integer('unit_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}