<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientPointsTable extends Migration {

	public function up()
	{
		Schema::create('client_points', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id')->unsigned();
			$table->integer('service_id')->unsigned()->nullable();
			$table->integer('points');
			$table->integer('order_id')->unsigned();
			$table->enum('status', array('1', '2', '3'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('client_points');
	}
}