<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServicesTable extends Migration {

	public function up()
	{
		Schema::create('services', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 150);
			$table->text('note')->nullable();
			$table->integer('service_category_id')->unsigned();
			$table->integer('branch_id')->unsigned();
			$table->double('normal_price');
			$table->enum('offer_type', array('1', '2'));
			$table->double('offer_value')->nullable();
			$table->double('offer_price');
			$table->date('offer_from_date')->nullable();
			$table->date('offer_to_date')->nullable();
			$table->integer('points');
			$table->enum('for_gender', array('1', '2', '3'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('services');
	}
}