<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRatesTable extends Migration {

	public function up()
	{
		Schema::create('rates', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('client_id')->unsigned();
			$table->integer('branch_id')->unsigned();
			$table->integer('rate');
			$table->text('comment')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('rates');
	}
}