<?php

namespace Models/BranchDistrict;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BranchDistrict extends Model 
{

    protected $table = 'branch_districts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function branch()
    {
        return $this->belongsTo('Branch', 'branch_id');
    }

    public function district()
    {
        return $this->belongsTo('District', 'district_id');
    }

}