<?php

namespace Models/Cart;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Cart extends Model 
{

    protected $table = 'carts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function client()
    {
        return $this->belongsTo('Client', 'client_id');
    }

    public function branch()
    {
        return $this->belongsTo('Branch', 'branch_id');
    }

    public function service()
    {
        return $this->belongsTo('Service', 'service_id');
    }

}