<?php

namespace Models/ClientBranchFavourite;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ClientBranchFavourite extends Model 
{

    protected $table = 'client_branch_favourites';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function branch()
    {
        return $this->belongsTo('Branch', 'branch_id');
    }

    public function client()
    {
        return $this->belongsTo('Client', 'client_id');
    }

}