<?php

namespace Models/ClientGift;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ClientGift extends Model 
{

    protected $table = 'client_gifts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function clientFrom()
    {
        return $this->belongsTo('Client', 'from_client_id');
    }

    public function clientTo()
    {
        return $this->belongsTo('Client', 'to_client_id');
    }

    public function order()
    {
        return $this->belongsTo('Order', 'order_id');
    }

}