<?php

namespace Models/Coupon;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Coupon extends Model 
{

    protected $table = 'coupons';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function vendor()
    {
        return $this->belongsTo('Vendor', 'vendor_id');
    }

    public function branch()
    {
        return $this->belongsTo('Branch', 'branch_id');
    }

    public function service()
    {
        return $this->belongsTo('Service', 'service_id');
    }

    public function serviceCategory()
    {
        return $this->belongsTo('ServiceCategory', 'service_category_id');
    }

}