<?php

namespace Models/Rate;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Rate extends Model 
{

    protected $table = 'rates';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function branch()
    {
        return $this->belongsTo('Branch', 'branch_id');
    }

    public function client()
    {
        return $this->belongsTo('Client', 'client_id');
    }

}