<?php

namespace Models/Vendor;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Vendor extends Model 
{

    protected $table = 'vendors';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function city()
    {
        return $this->belongsTo('City', 'city_id');
    }

    public function vendorType()
    {
        return $this->belongsTo('VendorType', 'vendor_type');
    }

}