<?php

namespace Models/ClientPoint;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ClientPoint extends Model 
{

    protected $table = 'client_points';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function client()
    {
        return $this->belongsTo('Client', 'client_id');
    }

    public function order()
    {
        return $this->belongsTo('Order', 'order_id');
    }

    public function service()
    {
        return $this->belongsTo('Service', 'service_id');
    }

}